# Optimization Dynamics of Equivariant and Augmented Networks

This code is included for transparency and reproducibility purposes.

## Description of files in the repository
* eqv_vs_aug_dyn_experiment_local.py contains the code for running the actual experiment.
Please note that this program will create a directory and store in it the experiment data (as NumPy arrays). 
* networks.py contains the code for the networks used in the experiment.
* mymse.py contains code for the loss function used in the experiment. 
* plot_experiment_data.py contains code for creating the plot seen in the paper.
If one wishes to make other plots from the data stored when running eqv_vs_aug_dyn_experiment_local.py, one would have to modify plot_experiment_data.py in the appropriate way.
* trainer_local.py contains the code for training the networks.
* tester_local contains the code for testing the networks.

### Required libraries
The code requires the [pytorch](https://pytorch.org/), [numpy](https://numpy.org/), [matplotlib](https://matplotlib.org/), [math](https://docs.python.org/3/library/math.html), [os](https://docs.python.org/3/library/os.html) and [tqdm](https://tqdm.github.io/) packages. The package [matplotlib](https://matplotlib.org/) is required only to run the code which creates the plot seen in the paper.

## Running experiments
To run the experiment from the paper simply run the file eqv_vs_aug_dyn_experiment_local.py. This may take a while depending on the computer used to run it. If one wishes to run a scaled-down version of the experiment one can go into the code and change the number of experiments and/or the number of training epochs (The corresponding parameters are situated near the top of the code). Note that the number of experiments should be divisible by 3, because there are 3 separate trials which are compared.

### Disclaimers
The experiments in the paper were performed on a cluster. Therefore, some aspects of the code differs very slightly from the code released here. There should be no difference in performance.



